#include <windows.h>
#include "gdigit.h"

POINT pt1[] = { { 20, 20 }, { 20, 70 }, { 30, 60 }, { 30, 30 } };
POINT pt2[] = { { 22, 18 }, { 32, 28 }, { 62, 28 }, { 72, 18 } };
POINT pt3[] = { { 20, 74 }, { 20, 124 }, { 30, 114 }, { 30, 84 } };
POINT pt4[] = { { 22, 72 }, { 32, 78 }, { 52, 78 }, { 72, 72 }, { 62, 66 }, { 42, 66 } };
POINT pt5[] = { { 22, 126 }, { 72, 126 }, { 62, 116 }, { 32, 116 } };
POINT pt6[] = { { 74, 20 }, { 64, 30 }, { 64, 60 }, { 74, 70 } };
POINT pt7[] = { { 74, 74 }, { 64, 84 }, { 64, 114 }, { 74, 124 } };
POINT ptcolon[] = { { 47, 55 }, { 47, 94 } };

void drawdigit(HDC hDC, int digit, int x, int y, HBRUSH hBrush)
{
    HRGN hRgn;
    POINT pt[6];
    char onoff;
    /* PATTERN: */
    /*  222222  */
    /* 1      6 */
    /* 1      6 */
    /* 1      6 */
    /*  444444  */
    /* 3      7 */
    /* 3      7 */
    /* 3      7 */
    /*  555555  */
    switch( digit )
    {
    case 1:
        onoff = 0x60;
        break;
    case 2:
        onoff = 0x3E;
        break;
    case 3:
        onoff = 0x7A;
        break;
    case 4:
        onoff = 0x69;
        break;
    case 5:
        onoff = 0x5B;
        break;
    case 6:
        onoff = 0x5F;
        break;
    case 7:
        onoff = 0x62;
        break;
    case 8:
        onoff = 0x7F;
        break;
    case 9:
        onoff = 0x7B;
        break;
    case 0:
        onoff = 0x77;
        break;
    }
    if( onoff & 0x01 )
    {
        gd_convertpoint(x, y, pt, pt1, 4);
        hRgn = CreatePolygonRgn(pt, 4, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( onoff & 0x02 )
    {
        gd_convertpoint(x, y, pt, pt2, 4);
        hRgn = CreatePolygonRgn(pt, 4, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( onoff & 0x04 )
    {
        gd_convertpoint(x, y, pt, pt3, 4);
        hRgn = CreatePolygonRgn(pt, 4, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( onoff & 0x08 )
    {
        gd_convertpoint(x, y, pt, pt4, 6);
        hRgn = CreatePolygonRgn(pt, 6, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( onoff & 0x10 )
    {
        gd_convertpoint(x, y, pt, pt5, 4);
        hRgn = CreatePolygonRgn(pt, 4, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( onoff & 0x20 )
    {
        gd_convertpoint(x, y, pt, pt6, 4);
        hRgn = CreatePolygonRgn(pt, 4, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( onoff & 0x40 )
    {
        gd_convertpoint(x, y, pt, pt7, 4);
        hRgn = CreatePolygonRgn(pt, 4, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
}

DWORD getdigitextent(void)
{
    return (DWORD)(GDIGIT_EXTENT_X + 0x10000 * GDIGIT_EXTENT_Y);
}

void gd_convertpoint(int x, int y, POINT *pt, POINT *oript, int count)
{
    int i;
    for( i = 0; i < count; i++ )
    {
        pt[i].x = x + oript[i].x - GDIGIT_PADDING_X - (oript[i].y - GDIGIT_PADDING_Y) * GDIGIT_BACKINDENT / (GDIGIT_EXTENT_Y - GDIGIT_PADDING_Y);
        pt[i].y = y + oript[i].y - GDIGIT_PADDING_Y;
    }
}

void drawcolon(HDC hDC, int x, int y, HBRUSH hBrush, HPEN hPen)
{
    int x1, y1, x2, y2;
    POINT pt[2];
    HBRUSH hOldBrush;
    HPEN hOldPen;
    hOldBrush = SelectObject(hDC, hBrush);
    hOldPen = SelectObject(hDC, hPen);
    gd_convertpoint(x, y, pt, ptcolon, 2);
    x1 = pt[0].x - GDIGIT_CLNRADIUS;
    y1 = pt[0].y - GDIGIT_CLNRADIUS;
    x2 = x1 + 2 * GDIGIT_CLNRADIUS; y2 = y1 + 2 * GDIGIT_CLNRADIUS;
    Ellipse(hDC, x1, y1, x2, y2);
    x1 = pt[1].x - GDIGIT_CLNRADIUS;
    y1 = pt[1].y - GDIGIT_CLNRADIUS;
    x2 = x1 + 2 * GDIGIT_CLNRADIUS; y2 = y1 + 2 * GDIGIT_CLNRADIUS;
    Ellipse(hDC, x1, y1, x2, y2);
    SelectObject(hDC, hOldBrush);
    SelectObject(hDC, hOldPen);
}
