' Search for "INSERT HERE" and insert your drawing code

Imports System
Imports System.Drawing
Imports System.Windows.Forms

NameSpace RobbieProgs

    Public Class DrawTemplate

        Public Shared Function Main() As Integer
            Try
                RunProgram()
                Return 0
            Catch ex As Exception
                Return 1
            End Try
        End Function

        Public Shared Sub RunProgram()
            Using form As New DrawTemplateForm()
                form.ShowDialog()
            End Using
        End Sub

    End Class

    Public Class DrawTemplateForm
            Inherits Form

        Const BitmapWidth As Integer = 640
        Const BitmapHeight As Integer = 480
        Private bmpImage1 As Bitmap
        Private pbxImage1 As PictureBox

        Public Sub New()
            InitComponents()
        End Sub

        Private Sub Form_Load(sender As Object, e As EventArgs)
            Dim graph1 As Graphics

            Me.Width = Me.Width + (BitmapWidth - Me.ClientRectangle.Width)
            Me.Height = Me.Height + (BitmapHeight - Me.ClientRectangle.Height)
            bmpImage1 = New Bitmap(BitmapWidth, BitmapHeight)
            pbxImage1.Image = bmpImage1
            graph1 = Graphics.FromImage(bmpImage1)
            DrawImage(graph1)
            graph1.Dispose()
        End Sub

        Private Sub DrawImage(graph As Graphics)
            Dim brsBlack As New SolidBrush(Color.FromArgb(0, 0, 0))
            Dim penBlack As New Pen(Color.FromArgb(0, 0, 0))
            Dim penWhite As New Pen(Color.FromArgb(255, 255, 255))

            graph.DrawRectangle(penBlack, 0, 0, BitmapWidth, BitmapHeight)
            graph.FillRectangle(brsBlack, 0, 0, BitmapWidth, BitmapHeight)
            ' INSERT HERE
            ' Example
            Dim aptPoints1() As Point = { _
                New Point(20, 20), _
                New Point(20, 70), _
                New Point(30, 60), _
                New Point(30, 30)  }
            Dim aptPoints2() As Point = { _
                New Point(22, 18), _
                New Point(32, 28), _
                New Point(62, 28), _
                New Point(72, 18)  }
            Dim aptPoints3() As Point = { _
                New Point(20, 74),  _
                New Point(20, 124), _
                New Point(30, 114), _
                New Point(30, 84)   }
            ' changes:
            ' Y: 78 to 77
            ' Y: 66 to 67
            ' X: 22 to 23
            ' X: 72 to 71
            ' X: 32 to 37
            ' X: 62 to 57
            ' X: 52 to 57
            ' X: 42 to 37
            Dim aptPoints4() As Point = { _
                New Point(23, 72), _
                New Point(37, 77), _
                New Point(57, 77), _
                New Point(71, 72), _
                New Point(57, 67), _
                New Point(37, 67)  }
            Dim aptPoints5() As Point = { _
                New Point(22, 126), _
                New Point(72, 126), _
                New Point(62, 116), _
                New Point(32, 116)  }
            Dim aptPoints6() As Point = { _
                New Point(74, 20), _
                New Point(64, 30), _
                New Point(64, 60), _
                New Point(74, 70)  }
            Dim aptPoints7() As Point = { _
                New Point(74, 74),  _
                New Point(64, 84),  _
                New Point(64, 114), _
                New Point(74, 124)  }
            Dim aaptPolygons()() As Point = { _
                aptPoints1, _
                aptPoints2, _
                aptPoints3, _
                aptPoints4, _
                aptPoints5, _
                aptPoints6, _
                aptPoints7  }
            For Each aptPolygon() As Point In aaptPolygons
                ConvertPolygon(aptPolygon)
                graph.DrawPolygon(penWhite, aptPolygon)
            Next
	    graph.DrawPolygon(penWhite, 
            ' End Example
            brsBlack.Dispose()
            penBlack.Dispose()
            penWhite.Dispose()
        End Sub

        Private Sub ConvertPolygon(aptPolygon() As Point)
            Const GDIGIT_EXTENT_X   As Integer = 80
            Const GDIGIT_EXTENT_Y   As Integer = 126
            Const GDIGIT_PADDING_X  As Integer = 20
            Const GDIGIT_PADDING_Y  As Integer = 18
            Const GDIGIT_BACKINDENT As Integer = 7
            Dim i As Integer
            Dim x As Integer = 0
            Dim y As Integer = 0
            Dim aptPolygon2(0 To aptPolygon.Length - 1) As Point

            For i = 0 To aptPolygon.Length - 1
                aptPolygon2(i).X = _
                    x + aptPolygon(i).X - GDIGIT_PADDING_X - (aptPolygon(i).Y - GDIGIT_PADDING_Y) * GDIGIT_BACKINDENT / (GDIGIT_EXTENT_Y - GDIGIT_PADDING_Y)
                aptPolygon2(i).Y = y + aptPolygon(i).Y - GDIGIT_PADDING_Y
            Next
            aptPolygon2.CopyTo(aptPolygon, 0)
        End Sub

        Private Sub Form_Closed(sender As Object, e As EventArgs)
            pbxImage1.Image = Nothing
            bmpImage1.Dispose()
        End Sub

        Private Sub InitComponents()
            AddHandler Me.Load, AddressOf Form_Load
            AddHandler Me.Closed, AddressOf Form_Closed
            pbxImage1 = New PictureBox()
            pbxImage1.Name = "pbxImage1"
            pbxImage1.Dock = DockStyle.Fill
            Me.Controls.Add(pbxImage1)
        End Sub

    End Class

End NameSpace
