' Search for "INSERT HERE" and insert your drawing code

Imports System
Imports System.Drawing
Imports System.Windows.Forms

NameSpace RobbieProgs

    Public Class DrawTemplate

        Public Shared Function Main() As Integer
            Try
                RunProgram()
                Return 0
            Catch ex As Exception
                Return 1
            End Try
        End Function

        Public Shared Sub RunProgram()
            Using form As New DrawTemplateForm()
                form.ShowDialog()
            End Using
        End Sub

    End Class

    Public Class DrawTemplateForm
            Inherits Form

        Const BitmapWidth As Integer = 640
        Const BitmapHeight As Integer = 480
        Private bmpImage1 As Bitmap
        Private pbxImage1 As PictureBox

        Public Sub New()
            InitComponents()
        End Sub

        Private Sub Form_Load(sender As Object, e As EventArgs)
            Dim graph1 As Graphics

            Me.Width = Me.Width + (BitmapWidth - Me.ClientRectangle.Width)
            Me.Height = Me.Height + (BitmapHeight - Me.ClientRectangle.Height)
            bmpImage1 = New Bitmap(BitmapWidth, BitmapHeight)
            pbxImage1.Image = bmpImage1
            graph1 = Graphics.FromImage(bmpImage1)
            DrawImage(graph1)
            graph1.Dispose()
        End Sub

        Private Sub DrawImage(graph As Graphics)
            Dim brsBlack As New SolidBrush(Color.FromArgb(0, 0, 0))
            Dim penBlack As New Pen(Color.FromArgb(0, 0, 0))
            Dim penWhite As New Pen(Color.FromArgb(255, 255, 255))

            graph.DrawRectangle(penBlack, 0, 0, BitmapWidth, BitmapHeight)
            graph.FillRectangle(brsBlack, 0, 0, BitmapWidth, BitmapHeight)
            ' INSERT HERE
            ' Example
            Dim aptPoints1() As Point = { _
                New Point(21, 21), _
                New Point(20, 24), _
                New Point(20, 67), _
                New Point(21, 70), _
                New Point(30, 61), _
                New Point(30, 30)  }
            Dim aptPoints2() As Point = { _
                New Point(71, 19), _
                New Point(68, 18), _
                New Point(26, 18), _
                New Point(23, 19), _
                New Point(32, 28), _
                New Point(62, 28)  }
            Dim aptPoints3() As Point = { _
                New Point(21, 74),  _
                New Point(20, 77),  _
                New Point(20, 120), _
                New Point(21, 123), _
                New Point(30, 114), _
                New Point(30, 83)   }
            ' changes:
            ' Y: 78 to 77
            ' Y: 66 to 67
            ' X: 22 to 23
            ' X: 72 to 71
            ' X: 32 to 37
            ' X: 62 to 57
            ' X: 52 to 57
            ' X: 42 to 37
            Dim aptPoints4() As Point = { _
                New Point(23, 72), _
                New Point(37, 77), _
                New Point(57, 77), _
                New Point(71, 72), _
                New Point(57, 67), _
                New Point(37, 67)  }
            Dim aptPoints5() As Point = { _
                New Point(23, 125), _
                New Point(26, 126), _
                New Point(68, 126), _
                New Point(71, 125), _
                New Point(62, 116), _
                New Point(32, 116)  }
            Dim aptPoints6() As Point = { _
                New Point(73, 70), _
                New Point(74, 67), _
                New Point(74, 24), _
                New Point(73, 21), _
                New Point(64, 30), _
                New Point(64, 61)  }
            Dim aptPoints7() As Point = { _
                New Point(73, 124), _
                New Point(74, 121), _
                New Point(74, 77),  _
                New Point(73, 74),  _
                New Point(64, 83),  _
                New Point(64, 115)  }
            Dim aaptPolygons()() As Point = { _
                aptPoints1, _
                aptPoints2, _
                aptPoints3, _
                aptPoints4, _
                aptPoints5, _
                aptPoints6, _
                aptPoints7  }
            For Each aptPolygon() As Point In aaptPolygons
                graph.DrawPolygon(penWhite, aptPolygon)
            Next
            ' End Example
            brsBlack.Dispose()
            penBlack.Dispose()
            penWhite.Dispose()
        End Sub

        Private Sub Form_Closed(sender As Object, e As EventArgs)
            pbxImage1.Image = Nothing
            bmpImage1.Dispose()
        End Sub

        Private Sub InitComponents()
            AddHandler Me.Load, AddressOf Form_Load
            AddHandler Me.Closed, AddressOf Form_Closed
            pbxImage1 = New PictureBox()
            pbxImage1.Name = "pbxImage1"
            pbxImage1.Dock = DockStyle.Fill
            Me.Controls.Add(pbxImage1)
        End Sub

    End Class

End NameSpace
