#include <windows.h>
#include <assert.h>
#include "gdigit.h"

//POINT apt1[] = { { 20, 20 }, { 20, 70 }, { 30, 60 }, { 30, 30 } };
//POINT apt2[] = { { 22, 18 }, { 32, 28 }, { 62, 28 }, { 72, 18 } };
//POINT apt3[] = { { 20, 74 }, { 20, 124 }, { 30, 114 }, { 30, 84 } };
//POINT apt4[] = { { 22, 72 }, { 32, 78 }, { 52, 78 }, { 72, 72 }, { 62, 66 }, { 42, 66 } };
//POINT apt5[] = { { 22, 126 }, { 72, 126 }, { 62, 116 }, { 32, 116 } };
//POINT apt6[] = { { 74, 20 }, { 64, 30 }, { 64, 60 }, { 74, 70 } };
//POINT apt7[] = { { 74, 74 }, { 64, 84 }, { 64, 114 }, { 74, 124 } };
POINT apt1[] = { { 21, 21 }, { 20, 24 }, { 20, 67 }, { 21, 70 },
    { 30, 61 }, { 30, 30 } };
POINT apt2[] = { { 71, 19 }, { 68, 18 }, { 26, 18 }, { 23, 19 },
    { 32, 28 }, { 62, 28 } };
POINT apt3[] = { { 21, 74 }, { 20, 77 }, { 20, 120 }, { 21, 123 },
    { 30, 114 }, { 30, 83 } };
POINT apt4[] = { { 23, 72 }, { 37, 77 }, { 57, 77 }, { 71, 72 },
    { 57, 67 }, { 37, 67 } };
POINT apt5[] = { { 23, 125 }, { 26, 126 }, { 68, 126 }, { 71, 125 },
    { 62, 116 }, { 32, 116 } };
POINT apt6[] = { { 73, 70 }, { 74, 67 }, { 74, 24 }, { 73, 21 },
    { 64, 30 }, { 64, 61 } };
POINT apt7[] = { { 73, 124 }, { 74, 121 }, { 74, 77 }, { 73, 74 },
    { 64, 83 }, { 64, 115 } };
POINT aptColon[] = { { 47, 55 }, { 47, 94 } };
enum {
    /* outer stroke point count: apt1, apt2, apt3, apt5, apt6, apt7 */
    OUTERSPC = 6,
    /* inner stroke point count: apt4 */
    INNERSPC = 6,
    /* max stroke point count: max(OUTERSPC, INNERSPC) */
    MAXSPC = 6,
};

void DrawDigit(HDC hDC, int nDigit, int x, int y, HBRUSH hBrush)
{
    /* PATTERN: */
    /*  222222  */
    /* 1      6 */
    /* 1      6 */
    /* 1      6 */
    /*  444444  */
    /* 3      7 */
    /* 3      7 */
    /* 3      7 */
    /*  555555  */
    char acDigitPatterns[] =
    { 
        0x77, /* nDigit 0 */
        0x60,       /* 1 */
        0x3E,       /* 2 */
        0x7A,       /* 3 */
        0x69,       /* 4 */
        0x5B,       /* 5 */
        0x5F,       /* 6 */
        0x62,       /* 7 */
        0x7F,       /* 8 */
        0x7B,       /* 9 */
    };
    HRGN hRgn;
    POINT aptPolygon[MAXSPC];
    char cDigitPattern;

    assert(0 <= nDigit && nDigit <= 9);
    cDigitPattern = acDigitPatterns[nDigit];
    if( cDigitPattern & 0x01 )
    {
        gd_ConvertPoint(x, y, aptPolygon, apt1, OUTERSPC);
        /* FIXME: error handling of CreatePolygonRgn */
        hRgn = CreatePolygonRgn(aptPolygon, OUTERSPC, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( cDigitPattern & 0x02 )
    {
        gd_ConvertPoint(x, y, aptPolygon, apt2, OUTERSPC);
        hRgn = CreatePolygonRgn(aptPolygon, OUTERSPC, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( cDigitPattern & 0x04 )
    {
        gd_ConvertPoint(x, y, aptPolygon, apt3, OUTERSPC);
        hRgn = CreatePolygonRgn(aptPolygon, OUTERSPC, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( cDigitPattern & 0x08 )
    {
        gd_ConvertPoint(x, y, aptPolygon, apt4, INNERSPC);
        hRgn = CreatePolygonRgn(aptPolygon, INNERSPC, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( cDigitPattern & 0x10 )
    {
        gd_ConvertPoint(x, y, aptPolygon, apt5, OUTERSPC);
        hRgn = CreatePolygonRgn(aptPolygon, OUTERSPC, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( cDigitPattern & 0x20 )
    {
        gd_ConvertPoint(x, y, aptPolygon, apt6, OUTERSPC);
        hRgn = CreatePolygonRgn(aptPolygon, OUTERSPC, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
    if( cDigitPattern & 0x40 )
    {
        gd_ConvertPoint(x, y, aptPolygon, apt7, OUTERSPC);
        hRgn = CreatePolygonRgn(aptPolygon, OUTERSPC, ALTERNATE);
        FillRgn(hDC, hRgn, hBrush);
        DeleteObject(hRgn);
    }
}

DWORD GetDigitExtent(void)
{
    return (DWORD)(GDIGIT_EXTENT_X + 0x10000 * GDIGIT_EXTENT_Y);
}

void DrawColon(HDC hDC, int x, int y, HBRUSH hBrush, HPEN hPen)
{
    int x1, y1, x2, y2;
    POINT apt[2];
    HBRUSH hbrOld;
    HPEN hpenOld;

    hbrOld = SelectObject(hDC, hBrush);
    hpenOld = SelectObject(hDC, hPen);
    gd_ConvertPoint(x, y, apt, aptColon, 2);
    x1 = apt[0].x - GDIGIT_CLNRADIUS;
    y1 = apt[0].y - GDIGIT_CLNRADIUS;
    x2 = x1 + 2 * GDIGIT_CLNRADIUS;
    y2 = y1 + 2 * GDIGIT_CLNRADIUS;
    Ellipse(
        hDC,
        x1, y1, /* upper left corner of bounding rectangle */
        x2, y2  /* lower right corner */
    );
    x1 = apt[1].x - GDIGIT_CLNRADIUS;
    y1 = apt[1].y - GDIGIT_CLNRADIUS;
    x2 = x1 + 2 * GDIGIT_CLNRADIUS;
    y2 = y1 + 2 * GDIGIT_CLNRADIUS;
    Ellipse(hDC, x1, y1, x2, y2);
    SelectObject(hDC, hbrOld);
    SelectObject(hDC, hpenOld);
}

/**
 *  gd_ConvertPoint:
 *      (Graphical Digit function) Converts an original digit polygon to the
 *      actual polygon for drawing.
 *
 *  Parameters:
 *      x - the horizontal position of the upper left corner of the digit
 *      y - the vertical position of the upper left corner
 *      aptDest - destination array of points to store converted positions
 *      aptOriginal - the original array of points of the digit polygon (one
 *          stroke in digit)
 *      nPtCnt - point count
 */
void gd_ConvertPoint(int x, int y, POINT *aptDest, POINT *aptOriginal, int nPtCnt)
{
    int i;

    for( i = 0; i < nPtCnt; i++ )
    {
        aptDest[i].x =
            x /* base x position */
            + aptOriginal[i].x - GDIGIT_PADDING_X /* unpad the x position */
            -
            (aptOriginal[i].y - GDIGIT_PADDING_Y) /* unpad y */
            *
            GDIGIT_BACKINDENT
            / (GDIGIT_EXTENT_Y - GDIGIT_PADDING_Y); /* compute the weight of */
                                                    /* back indent */

        aptDest[i].y =
            y /* base y position */
            + aptOriginal[i].y - GDIGIT_PADDING_Y; /* unpad y */
    }
}

