#include "ioadapt.h"
#include <io.h>
#include <stdlib.h>

char *io_GetLine(char *pszBuf, int hFile, int nSize)
{
    char c;
    int ret;
    int i = 0;
    int fEOF = 0;

    if( nSize > 4096 || nSize < 1 || hFile == -1 || pszBuf == NULL )
        return NULL;

    for (;;)
    {
        if( i >= nSize - 1 )
            break;

        ret = read(hFile, &c, 1);
        if(
            ret == 0        /* EOF */
            || ret == -1    /* error */
        )
        {
            fEOF = 1;
            break;
        }
        if( c == '\n' )
            break;

        pszBuf[i] = c;
        i++;
    }

    pszBuf[i] = '\0';
    if( fEOF )
        return NULL;

    return pszBuf;
}
