import datetime
import os
import sys
import time
import traceback

sys.path.append("C:\\cmdtools")

from robbiecommon_py3 import (ClineSwitch, ClineFilter, ListFilesRecursive)

def main():
    switches = [ClineSwitch("p", "path", True)]
    filter = ClineFilter(switches, sys.argv)
    filter.filter()
    if not filter.swdict["s:p"].switched:
        print("Missing the -p or --path switch.")
        show_help()
        return 2
    root_path = filter.swdict["s:p"].aarg
    lister = ListFilesRecursive(root_path, ["*.md5"])
    seq_holder = [0]
    for path in lister.get_list():
        full_path = os.path.realpath(path)
        try:
            process_file_case_dir(full_path, seq_holder)
        except:
            print("Exception ocurred {")
            print("When processing \"" + full_path + "\"")
            traceback.print_exc()
            print("} Exception ocurred")
        try:
            process_file_case_file(full_path, seq_holder)
        except:
            print("Exception ocurred {")
            print("When processing \"" + full_path + "\"")
            traceback.print_exc()
            print("} Exception ocurred")
    return 0

def process_file_case_dir(full_path, seq_holder):
    seq = seq_holder[0]
    dir_path = os.path.splitext(full_path)[0]
    if os.path.isdir(dir_path):
        tmp_file_path1 = os.path.join(os.environ["temp"], "md5_discover_verify_py_temp.md5")
        if os.path.isfile(tmp_file_path1):
            os.unlink(tmp_file_path1)
        run_cmd("winrun --wait -d \"" + dir_path + "\" cmd /c md5deep -l -l -l -r * -l or sort -l gt \""
            + tmp_file_path1 + "\"")
        tmp_file_path2 = os.path.join(os.environ["temp"], "md5_discover_verify_py_ref.md5")
        if os.path.isfile(tmp_file_path2):
            os.unlink(tmp_file_path2)
        run_cmd("winrun --wait cmd /c sort -l lt \"" + full_path + "\" -l gt \"" + tmp_file_path2
            + "\"")
        log_file_path = os.path.join(os.environ["temp"], "md5_discover_verify_py_log_" + datetime
            .datetime.now(datetime.timezone.utc).strftime("%Y%m%d_%H%M%S") + "_" + str(seq) + ".log")
        seq += 1
        seq_holder[0] = seq
        run_cmd("gnudiff \"" + tmp_file_path1 + "\" \"" + tmp_file_path2 + "\" | pr2013 \"" + log_file_path + "\"")
    # else don't do anything

def process_file_case_file(full_path, seq_holder):
    seq = seq_holder[0]
    orig_path = os.path.splitext(full_path)[0]
    dir_path = os.path.split(orig_path)[0]
    if os.path.isfile(orig_path):
        tmp_file_path1 = os.path.join(os.environ["temp"], "md5_discover_verify_py_temp.md5")
        if os.path.isfile(tmp_file_path1):
            os.unlink(tmp_file_path1)
        run_cmd("winrun --wait -d \"" + dir_path + "\" cmd /c md5deep -l -l \"" + os.path
            .split(orig_path)[1] + "\" -l gt \"" + tmp_file_path1 + "\"")
        log_file_path = os.path.join(os.environ["temp"], "md5_discover_verify_py_log_" + datetime
            .datetime.now(datetime.timezone.utc).strftime("%Y%m%d_%H%M%S") + "_" + str(seq) + ".log")
        seq += 1
        seq_holder[0] = seq
        run_cmd("gnudiff \"" + tmp_file_path1 + "\" \"" + full_path + "\" | pr2013 \"" + log_file_path + "\"")
    # else don't do anything

def run_cmd(cmd):
    print(cmd)
    os.system(cmd)

def show_help():
    print("Discovers *.md5 files automatically and calls md5deep to check relevant files.")
    print("You should run this script on a machine where Robbie Mosaic Fan's cmdtools is")
    print("installed. It depends on some tools like \"winrun\". Also you should have")
    print("GnuWin32 installed and on the path, and the diff.exe tool is available as")
    print("gnudiff.exe.")
    print("Usage:")
    print("python3 md5_discover_verify.py {-p <path>|--path <path>}")

if __name__ == "__main__":
    sys.exit(main())
