# vim: set sts=4 ts=4 sw=4 et nojs:

import os
import sys
from robbiecommon_py3 import ListFilesRecursive

def main():
    lister = ListFilesRecursive(patterns=["*.c", "*.h"])
    file_list = lister.get_list()
    for fpath in file_list:
        fpath = os.path.realpath(fpath)
        process_file(fpath)
    return 0

def process_file(fpath):
    file1 = None
    try:
        print("Reading {}".format(fpath))
        file1 = open(fpath, "r", encoding="utf-8")
        text = file1.read()
        file1.close()
        file1 = None
        print(text)
        if text.startswith("\ufeff"):
            print("Has BOM")
        else:
            print("No BOM")
            print("Is the text above okay [YN] ? ", end="")
            sys.stdout.flush()
            choice = ""
            while choice == "":
                choice = sys.stdin.readline().rstrip().lower()
            if choice == "y":
                print("Processing...")
                file1 = open(fpath, "w", encoding="utf-8")
                file1.write("\ufeff")
                file1.write(text)
                file1.close()
                file1 = None
                print("Processed")
            else:
                print("Please process it manually")
    finally:
        if file1 is not None:
            file1.close()
            file1 = None

if __name__ == "__main__":
    sys.exit(main())
