# vim: set sts=4 ts=4 sw=4 et nojs fo-=tcqro fo+=tcqro noswf enc=utf-8:

import os
import re
import secrets
import sys
import traceback
from robbiecommon_py3 import ListFilesRecursive

# msvc_2022_rm_msg_rand_upd.py
#   Robbie Mosaic's message random number update program. The messages have the following
#   format: "【1234567】 This is the error message"
#
#   The files are assumed to be in UTF-8 with BOM. If a file exists that doesn't meet
#   the encoding requirement, it is skipped and reported.
#
#   Run the command from the project directory.

g_DigitCount = 7
g_rand_set = set()

def main():
    lister = ListFilesRecursive(patterns=["*.c"])
    filelist = lister.get_list()
    for fpath in filelist:
        fpath = os.path.realpath(fpath)
        process_file(fpath)
    return 0

def process_file(fpath):
    file1 = None
    try:
        file1 = open(fpath, "r", encoding="utf-8")
        print("Processing {} ...".format(fpath))
        try:
            text = file1.read()
        except:
            print(("Error processing file {}, maybe its encoding is not UTF-8. Use VSCode to fix"
                  + " it.").format(fpath))
            traceback.print_exc()
        if text.startswith("\ufeff"):
            chg_flag_holder = [False]
            text_no_bom = process_text(text[1:], chg_flag_holder)
            if chg_flag_holder[0]:
                #print(text_no_bom)
                os.system("copy /-y \"{}\" \"{}\"".format(fpath, fpath + ".bak"))
                file1 = open(fpath, "w", encoding="utf-8")
                file1.write("\ufeff")
                file1.write(text_no_bom)
                file1.close()
                file1 = None
        else:
            print("The file is in UTF-8 encoding but doesn't have BOM. Please run msvc_2022_bom_ensure.py"
                 + " to fix it.")
    finally:
        if file1 is not None:
            file1.close()
            file1 = None

def process_text(text, chg_flag_holder):
    text_overwrites = [] # member type: TextOverwrite
    for randstr_match in re.finditer(r"【\d{7}】", text):
        if randstr_match.group(0) in g_rand_set:
            textovw = TextOverwrite(randstr_match.span(), "【{}】".format(get_random_number()))
            text_overwrites.append(textovw)
            g_rand_set.add(textovw.replstr)
        else:
            g_rand_set.add(randstr_match.group(0))
    chg_flag_holder[0] = len(text_overwrites) > 0
    start = 0
    result = []
    for textovw in text_overwrites:
        currlen = textovw.start - start
        result.append(text[start:start+currlen])
        result.append(textovw.replstr)
        start = textovw.start + textovw.length
    result.append(text[start:])
    start = len(text)
    return "".join(result)

def get_random_number():
    limit_plus_one = 1
    for i in range(g_DigitCount):
        limit_plus_one *= 10
    randnum = secrets.randbelow(limit_plus_one)
    while randnum < limit_plus_one // 10:
        randnum = secrets.randbelow(limit_plus_one)
    return randnum

class TextOverwrite(object):
    def __init__(self, span_tuple, replstr):
        start, end = span_tuple # note that match.span() is (start, end) rather than (start, length)
        self.start = start
        self.length = end - start
        self.replstr = replstr # replacement string

if __name__ == "__main__":
    sys.exit(main())
